<?php
/**************************************************************************
 * Copyright 2004 Jeremy March
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * jeremy_march@comcast.net
 * http://sourceforge.net/projects/tree-factory/
 *
 **************************************************************************/

//error_reporting(E_ALL);
ob_start();

require_once "lib_example1.php";
require_once "TF_nested_sets.php";
$allTimeStart = get_microtime();

/************Config************************/

// Connection Parameters
define('USER',       'treeuser');
define('PASSWORD',   '1234');
define('HOST',       'localhost');
define('DATABASE',   'trees');
define('MY_ROUND',   4);

$db_conn = mysql_pconnect('localhost', 'hydrarot_vinod', 'vinod69*') or die("Did Not Connect");
mysql_select_db(hydrarot_rototechold, $db_conn) or die("Did Not Select Database");

// Tree Parameters
define('TABLE_TYPE',  'myisam');  // e.g. 'myisam', 'innodb', or 'none'
define('DEBUG',       TRUE);

// field heading
$fields  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'),'lnk'=>'link','compcode'=>'comp_code','searchkey'=>'searchkey');
//$fields1  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'),'lnk'=>'link','compcode'=>'comp_code');
//$fields2  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'),'lnk'=>'link','compcode'=>'comp_code');

$trees   = array();
$trees[] = new TF_ns_tree($db_conn, 'complaint_master', TABLE_TYPE, $fields, DEBUG);
//$trees[] = new TF_ns_tree($db_conn, 'reo_compliant', TABLE_TYPE, $fields1, DEBUG);
//$trees[] = new TF_ns_tree($db_conn, 'ycp_compliant', TABLE_TYPE, $fields2, DEBUG);

/************End-Config************************/

$numTrees = count($trees);

// states for output section
define('STATE_NO_NODE'       , 1);
define('STATE_NEW_RECORD'    , 2);
define('STATE_VALID'         , 3);
define('SPACES_PER_TAB'      , 4);
define('PICS_PER_TAB'        , 40);
?>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<style>
body { font-size:11pt; margin:5px; color:#0099FF; background:#256181; }
table { font-size:11pt; }
.all { width:800px; }

.titlediv
{
  width:800px;
  height:60px;
  margin-top:5px;
}
.bottomdiv { width:800px; text-align:center; }

.tree
{ float:right;
  padding-left:5px;
  padding-top:5px;
  width:400px;
  white-space:nowrap;
}
.lev0 { display:inline; }
.lev1 { display:none; }
.nodeToggle { cursor:pointer; }
.tree a { text-decoration:none; color:blue; }
	   a { color: #0000FF; }
	   	a {text-decoration:none}

.formdiv { width:395px; float:left; padding-top:5px;}
.formdiv td { border:2px solid white; padding:3px; }


.content
{ margin: 0px 10px;
  padding:10px;
  background-color: #FF9900;
}

.rtop, .bottom { position:relative; left:1px; height:11px; }
.rtop { top: -1px; }

.nw, .ne, .sw, .se { width:11px; height:11px; }
.nw, .sw { float:left; position:relative; left:-2px; }
.ne, .se { float:right; }

</style>
<script language='javascript'>
function formAction(action)
{
	document.myform.action.value = action;
	document.myform.submit();
}

function toggleDisplay(list)
{
	location.href = "<?php echo $_SERVER['PHP_SELF']; ?>?nodeid=<?php echo $_GET['nodeid']."&ntree=".$_GET['ntree']; ?>&list=" + list;
}

function expandIt(whichEl, whichButton)
{
	if (document.getElementById(whichEl).style.display == 'inline')
	{
		document.getElementById(whichEl).style.display = 'none';
		document.getElementById(whichButton).src = "images/plus.png";
	}
	else
	{
		document.getElementById(whichEl).style.display = 'inline';
		document.getElementById(whichButton).src = "images/minus.png";
	}
}

isExpanded = false;

function expandAll()
{
	divColl = document.getElementsByTagName("div");
	for (i = 0; i < divColl.length; i++)
	{
		if (divColl[i].className == "lev1")
		{
			divColl[i].style.display = (isExpanded) ? "none" : "inline";
		}
	}
	imgColl = document.getElementsByTagName("img");
	for (i = 0; i < imgColl.length; i++)
	{
		if (imgColl[i].className == "nodeToggle")
		{
			imgColl[i].src = (isExpanded) ? "images/plus.png" : "images/minus.png";
		}
	}
	isExpanded = !isExpanded;
	document.getElementById("exAll").value = (isExpanded) ? "Collapse" : "Expand";
}
<?php
//if term is selected create onLoad function to display list
if (isset($parents))
{
echo "
function expand_list()
{
	var idArray;
	var divID;
	var buttonID;
";

$iarray = $parents;

echo "\tidArray = new Array(";
echo implode(", ", $iarray);
if (count($iarray) < 2)
	echo ", 0";
echo ");\n";
echo "
	for (i = 0; i < idArray.length; i++)
	{
		divID = '".$n."i' + idArray[i];
		buttonID = '".$n."b' + idArray[i];
		document.getElementById(divID).style.display = 'inline';
		document.getElementById(buttonID).src = 'images/minus.png';
	}
}
";
}
?>
function togParents(id)
{
	for (i = 0; i < <?php echo $numTrees; ?>; i++)
	{
		var t = 't' + i;
		var p = 'p' + i;

		if (id == i)
		{
			document.getElementById(t).style.display = 'table-row';
			document.getElementById(p).name = 'parent';
			document.getElementById(p).disabled=false;
		}
		else
		{
			document.getElementById(t).style.display = 'none';
			document.getElementById(p).name = '';
			document.getElementById(p).disabled=true;
		}
	}
}
</script>
</head>
<body onLoad='expand_list()'>

<?
// Nachoine Heading
//echo $mach.'  Troubleshooting<br>'; 
//echo $searchkey;
/**********************************TREES**********************************/
for ($i = 0; $i < $numTrees; $i++)
{
	//$leftSpace = $i * 400; to be used for horizontal tree layout
	echo "<div class='formdiv'><div class='rtop'><div class='nw'></div><div class='ne'></div></div><div class='content'>\n";
	$rootId = $trees[$i]->getRootId();

	$rootNode = new node($rootId, $trees[$i]);

	if ($state != STATE_NEW_RECORD && $i == $n)
		$selected = $node->id;
	else
		$selected = NULL;
		
	if (isset($_GET['list']) && $_GET['list'] == 'debug')
	{
		display_tree_debug($rootNode, $i, TRUE, $selected);

			}
	else
		{
		display_tree_divs($rootNode, $i,$mach,$searchkey, FALSE, $selected);

		}
}

?>
</div>
</div>

</body>
</html>