<?php
/**************************************************************************
 * Copyright 2004 Jeremy March
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 * For the concept of nested set trees credit is due to Joe Celko and 
 * his book "SQL for Smarties."
 *
 * The rebuild() and getTreeArray() functions were derived (and modified)
 * from functions written by Gijs van Tulder and published in his article
 * found here: http://www.sitepoint.com/article/1105
 *
 * jeremy_march@comcast.net
 * http://sourceforge.net/projects/tree-factory/
 *
 **************************************************************************/

// ERROR CODES--remember to also add new error codes to array in _raiseError method
define('TFNS_ERROR_QUERY_FAILED',       -1);
define('TFNS_ERROR_NODE_NOT_FOUND',     -2);
define('TFNS_ERROR_RECURSION',          -3);
define('TFNS_ERROR_INCOMPATIBLE_TREES', -4);
define('TFNS_ERROR_INSERT_FAILED',      -5);

class node
{
	var $id;
	var $sortValue;
	var $left;
	var $right;
	var $htmlink;
	var $tree;
	var $up2date; // used in transactions to determine if properties are set

	/**
	 * no error checking is done to see if node exists because even if it exists
	 * when created it may not by the time an action is performed on it.  Therefore 
	 * we check that inside of the action transaction
	 * @param  $id   int
	 * @param  $tree object
	 * @access public
	 * @return null
	 */
	function node($id, &$tree)
	{
		$this->tree    = $tree;
		$this->id      = $id;
		$this->up2date = FALSE;
	}

	/**
	 * Set lft, rgt, sortValue, and orderBy properties inside of a transaction
	 *
	 * @access private
	 * @return int
	 */
	function _setNodeProps()
	{
		$query = sprintf("SELECT %s, %s, %s, %s,%s,%s,%s,%s,%s,%s FROM %s WHERE %s = %s;",
						$this->tree->leftFld,
						$this->tree->rightFld,
						implode(", ", $this->tree->orderByFld),
						$this->tree->linkFld,
						$this->tree->searchkeyFld,
						$this->tree->searchkey2Fld,
						$this->tree->searchkey3Fld,						
						$this->tree->searchkey4Fld,
						$this->tree->searchkey5Fld,												
						$this->tree->approachFld,						
						$this->tree->table,
						$this->tree->idFld,
						$this->id);
		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

		$numRows = mysql_num_rows($res);
		if ($numRows != 1)
			return $this->_raiseError(TFNS_ERROR_NODE_NOT_FOUND, __FUNCTION__, __LINE__, __FILE__, $query);

		$row = mysql_fetch_array($res);

		$count = count($this->tree->orderByFld);
		for ($i = 0; $i < $count; $i++)
		{
			//don't need to comma separate just to sort!
			$this->sortValue .= $row[$this->tree->orderByFld[$i]];
		}

		$this->left      = $row[$this->tree->leftFld];
		$this->right     = $row[$this->tree->rightFld];
		$this->htmlink   = $row[$this->tree->linkFld];
		$this->up2date   = TRUE;

		return 1;
	}

	/**
	 * @param  $errno    int
	 * @param  $function string
	 * @param  $file     string
	 * @param  $query    string (optional)
	 * @access private
	 * @return int
	 */
	function _raiseError($errno, $function, $line, $file, $query = NULL)
	{
		if ($this->tree->debug)
		{
			$errMsg = array(
				TFNS_ERROR_QUERY_FAILED       => 'Query Failed',
				TFNS_ERROR_NODE_NOT_FOUND     => 'Node not found',
				TFNS_ERROR_RECURSION          => 'Change would introduce recursion into the tree structure',
				TFNS_ERROR_INCOMPATIBLE_TREES => 'Trees in different tables must be compatible',
				TFNS_ERROR_INSERT_FAILED      => 'Wrong number of fields given to insertNode()'
				);

			echo "<b>Debug info<br />\n";				
			echo "Tree Error: ".$errMsg[$errno]."<br />\n";
			echo "In Function: ".$function."<br />\n";
			if (isset($query))
			{
				echo "Query: ".$query."<br />\n";
				echo "MySQL Error: ".mysql_error($this->tree->db_conn)."<br />\n";
			}
			echo "File: ".$file."<br />\n";
			echo "Line: ".$line."<br />\n";
			echo "</b>\n";
		}
		return $errno;
	}

	/**
	 * @param  $selectFields array
	 * @access public
	 * @return array or int
	 */
	function getTreeArray($selectFields)
	{
		if (!$this->up2date)
		{
			$res = $this->_setNodeProps();
			if ($res < 1)
				return $res;
		}
	
		$selectString = implode(", ", $selectFields);
		$treeArray = array();

		// start with an empty $right stack
		$right = array();

		// retrieve all descendants of the $this node
		$query = sprintf(  "SELECT %s, %s, %s FROM %s WHERE %s BETWEEN %s AND %s ORDER BY %s ASC;",
								$this->tree->leftFld,
								$this->tree->rightFld,
								$selectString,
								$this->tree->table,
								$this->tree->leftFld,
								$this->left,
								$this->right,
								$this->tree->leftFld);
								
		$result = mysql_query($query, $this->tree->db_conn);
		
		if (!$result)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

		// display each row
		$i = 0;
		while ($row = mysql_fetch_array($result))
		{
			$closeDiv = FALSE;
			$treeArray[$i]['close'] = 0;
  			// only check stack if there is one
			if (count($right) > 0)
			{
	          	// check if we should remove a node from the stack
	          	while ($right[count($right) - 1] < $row[$this->tree->rightFld])
				{
					// remove array elements until we find one bigger than $row[rgt]
		          	// need to add a check somewhere that there is in fact a bigger value in right--else endless loop
	               	array_pop($right);
	               	if ($closeDiv)	  // if we pop more than one element then we need to start closing divs
						$treeArray[$i]['close'] += 1;
					$closeDiv = TRUE;
				}
     	  	}
			// put tab count and each field into array to return
			$treeArray[$i]['tab'] = count($right);
			if ($row[$this->tree->rightFld] - $row[$this->tree->leftFld] != 1)
				$treeArray[$i]['open'] = TRUE; 
			else
				$treeArray[$i]['open'] = FALSE;

			foreach ($selectFields as $field)
			{
				$treeArray[$i][$field] = $row[$field];
			}
			$i++;
			// add this node to the stack
			$right[] = $row[$this->tree->rightFld];
		}
		return $treeArray;
	}

	/**
	 * @param  $limit int (optional)
	 * @access public
	 * @return array or int
	 */
	function getParents($limit = NULL)
	{
		$locks = array($this->tree->table . ' READ');

		$res = $this->_beginTrx($locks);
		if ($res < 1)
			return $res;
			
		$res = $this->_safeGetParents($limit);
		
		return $this->_endTrx($res);
	}

	/**
	 * @param  $limit int (optional)
	 * @access private
	 * @return array or int
	 */
	function _safeGetParents($limit = NULL)
	{
		if (!$this->up2date)
		{
			$res = $this->_setNodeProps();
			if ($res < 1)
				return $res;
		}
		
		if (isset($limit))
			$limit = "LIMIT $limit";

		$ancestors = array();

		$query = sprintf(  "SELECT %s FROM %s WHERE %s < %s AND %s > %s ORDER BY %s DESC %s;",
								$this->tree->idFld,
								$this->tree->table,
								$this->tree->leftFld,
								$this->left,
								$this->tree->rightFld,
								$this->right,
								$this->tree->leftFld,
								$limit);
		
		$result = mysql_query($query, $this->tree->db_conn);
		if (!$result)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
			
		while ($row = mysql_fetch_array($result))
		{
			$ancestors[] = $row[0];
		}
		return $ancestors;
	}

	/**
	 * @param  $limit int (optional)
	 * @access public
	 * @return array or int
	 */
	function getChildren($limit = NULL)
	{
		$locks = array($this->tree->table . ' READ');

		$res = $this->_beginTrx($locks);
		if ($res < 1)
			return $res;
			
		$res = $this->_safeGetChildren($limit);
		
		return $this->_endTrx($res);
	}

	/**
	 * @param  $limit int (optional)
	 * @access private
	 * @return array or int
	 */
	function _safeGetChildren($limit = NULL)
	{
		if (!$this->up2date)
		{
			$res = $this->_setNodeProps();
			if ($res < 1)
				return $res;
		}

		if (isset($limit))
			$limit = "LIMIT $limit";

		$descendents = array();

		$query = sprintf(  "SELECT %s FROM %s WHERE %s BETWEEN %s AND %s ORDER BY %s ASC %s;",
								$this->tree->idFld,
								$this->tree->table,
								$this->tree->leftFld,
								$this->left,
								$this->right,
								$this->tree->leftFld,
								$limit);

		$result = mysql_query($query, $this->tree->db_conn);
		if (!$result)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

		// display each row
		while ($row = mysql_fetch_array($result))
		{
			$descendents[] = $row[0];
		}
		return $descendents;
	}

	/**
	 * @access public
	 * @return int
	 */
	function getNumDescendents()
	{
		return ($this->right - $this->left - 1) / 2;
	}

	/**
	 * get array of all leaves--i.e. all terms with no children
	 *
	 * @access public
	 * @return array
	 */
	function getLeaves()
	{
		$leaves = array();

		// keep lft out of the expr. to allow it to use the lft index
		$query = sprintf(  "SELECT %s FROM %s WHERE %s = (%s - 1);",
									$this->idFld,
									$this->table,
									$this->leftFld,
									$this->rightFld);
		
		$result = mysql_query($query, $this->db_conn); 
		while($row = mysql_fetch_row($result))
		{
			$leaves[] = $row[0];
		}
		return $leaves;
	}

	/**
	 * get array of all nodes with children
	 * 
	 * @access public
	 * @return array
	 */
	function getNodes()
	{
		$nodes = array();

	  	// keep lft out of the expr. to allow it to use the lft index
		$query = sprintf(  "SELECT %s FROM %s WHERE %s != (%s - 1);",
								$this->idFld,
								$this->table,
								$this->leftFld,
								$this->rightFld);
		
		$res = mysql_query($query, $this->db_conn); 
		while ($row = mysql_fetch_row($res))
		{
			$nodes[] = $row[0];
		}
		return $nodes;
	}

	/**
	 * test echo term and level--works now.
	 * The GROUP BY is required by syntax only--needed because mix of aggregate "count..." and non-ag fields "p2.term" in select
	 */
	function testGetLevel()
	{
		$query = sprintf(   "SELECT P2.%s AS Term, (count(T1.%s) - 1) AS Level ".
							"FROM %s AS T1, %s AS T2 ".
							"WHERE T2.%s BETWEEN T1.%s AND T1.%s ".
							"GROUP BY T2.%s ORDER BY Level, %s;",
					'term',
					$this->idFld,
					$this->table,
					$this->table,
					$this->leftFld,
					$this->leftFld,
					$this->rightFld,
					$this->idFld,
					$this->orderByFld);
										
		$result = mysql_query($query, $this->db_conn) or die(mysql_error());

		echo "<table border='1'>";
		while ($row = mysql_fetch_row($result))
		{	
			echo "<tr><td>$row[0]</td><td>$row[1]</td></tr>";
		}
		echo "</table>";
	}

	/**
	 * return level of treenode--works now.
	 *
	 * @access public
	 * @return int
	 */
	function getLevel()
	{
		$query = sprintf(   "SELECT count(P1.%s) - 1 AS Level FROM %s AS T1, %s AS T2 ".
							"WHERE T2.%s BETWEEN T1.%s AND T1.%s AND T2.%s = %s;",
							$this->idFld,
							$this->table,
							$this->table,
							$this->leftFld,
							$this->leftFld,
							$this->rightFld,
							$this->idFld,
							$this->id);

		$res = mysql_query($query, $this->db_conn) or die(mysql_error());
		$row = mysql_fetch_row($res);

		return $row[0];
	}

	/**
	 * @param $locks array (optional: used only for myisam tables)
	 * @access private
	 * @return int
	 */
	function _beginTrx($locks = NULL)
	{
		if ($this->tree->tableType == 'innodb')
		{
			$res = mysql_query("BEGIN;", $this->tree->db_conn);
			if (!$res)
				return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
			return 1;
		}
		elseif ($this->tree->tableType == 'myisam')
		{
			if (is_array($locks))
			{
				$query  = "LOCK TABLES ";
				$query .= implode(', ', $locks) . ";";

				$res = mysql_query($query, $this->tree->db_conn);
				if (!$res)
					return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
			}
			return 1;
		}
		elseif ($this->tree->tableType == 'none')
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	/**
	 * @param  $trxRes array or int
	 * @access private
	 * @return array or int
	 */
	function _endTrx($trxRes)
	{
		$this->up2date = FALSE;
		
		if ($this->tree->tableType == 'innodb')
		{
			// no need to check for array here because these aren't write queries anyway
			// doesn't matter commit or rollback
			if ($trxRes > 0)
			{
				$res = mysql_query("COMMIT;", $this->tree->db_conn);
				if ($res)
					return $trxRes;
			}
			mysql_query("ROLLBACK;", $this->tree->db_conn);
			return $trxRes;
		}
		elseif ($this->tree->tableType == 'myisam')
		{
			$res = mysql_query("UNLOCK TABLES;", $this->tree->db_conn);
			if (!$res)
				return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, 'UNLOCK TABLES;');
			else
				return $trxRes;
		}
		elseif ($this->tree->tableType == 'none')
		{
			return $trxRes;
		}
		else
		{
			return 0;
		}
	}

	/**
	 * only called by _findTarget() for use when orderByFld is more than one
	 */
	function _concatOrderByFld()
	{
		if (count($this->tree->orderByFld) > 1)
		{
			$sortByStr = implode(", C.", $this->tree->orderByFld);
			return "CONCAT(C.$sortByStr)";
		}
		else
		{
			return "C.".$this->tree->orderByFld[0];
		}
	}

	/**
	 * Finds insertion point under given parent based on order by field
	 *
	 * @param  $parent object
	 * @param  $insert_item string (optional)
	 * @access private
	 * @return int [= one less than insertion point or error code]
	 */
	function _findTarget($parent, $insertItem = null)
	{
		$query = sprintf(  "SELECT %s, %s FROM %s WHERE %s = %s;",
								$parent->tree->leftFld,
								$parent->tree->rightFld,
								$parent->tree->table,
								$parent->tree->idFld,
								$parent->id);

		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

		$num_rows = mysql_num_rows($res);
		if ($num_rows != 1)
			return $this->_raiseError(TFNS_ERROR_NODE_NOT_FOUND, __FUNCTION__, __LINE__, __FILE__, $query);

		$row = mysql_fetch_row($res);
		if ($row[1] - $row[0] != 1)  // parent has other children
		{
			if (is_null($insertItem))
			{
				$sortItem = $this->sortValue;
			}
			else
			{
				$sortItem = $insertItem;
			}

			// See if new_parent has other children and if so, select possible target
			// the second order by column is in case sibling nodes have same sort weight--use right-most one
			$query = sprintf(   "SELECT C.%s + 1 AS lft, C.%s AS rgt, P.%s ".
								"FROM %s AS C LEFT JOIN %s AS P ".
								"ON P.%s = (SELECT MAX(%s) FROM ".
								"(SELECT %s, %s FROM %s WHERE %s BETWEEN %s AND %s) AS S ".
								"WHERE C.%s > S.%s AND C.%s < S.%s) ".
								"WHERE P.%s = %s AND %s < '%s' ORDER BY C.%s DESC, C.%s DESC LIMIT 1;",
									$parent->tree->leftFld,
									$parent->tree->rightFld,
									$parent->tree->rightFld,
									$parent->tree->table,
									$parent->tree->table,
									$parent->tree->leftFld,
									$parent->tree->leftFld,
									$parent->tree->leftFld,
									$parent->tree->rightFld,
									$parent->tree->table,
									$parent->tree->leftFld,
									$row[0],
									$row[1],
									$parent->tree->leftFld,
									$parent->tree->leftFld,
									$parent->tree->leftFld,
									$parent->tree->rightFld,
									$parent->tree->idFld,
									$parent->id,
									$parent->_concatOrderByFld(),
									$sortItem,
									implode(" DESC, C.", $parent->tree->orderByFld),
									$parent->tree->leftFld);
							
			$res = mysql_query($query, $this->tree->db_conn);
			if (!$res)
				return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

			$numRows = mysql_num_rows($res);

			if ($numRows == 1) // if new_parent has other children find one sorted above node
			{
				$row = mysql_fetch_row($res);

				// see if target has its own children--if no, we're done
				if ($row[1] - ($row[0] - 1) != 1)
				{
					// if yes, its left most (max(lft)) child becomes the target
					$query = sprintf(  "SELECT MAX(%s) FROM %s WHERE %s BETWEEN %s AND %s;",
									$parent->tree->leftFld,
									$parent->tree->table,
									$parent->tree->leftFld,
									$row[0],
									$row[1]);

					$res = mysql_query($query, $this->tree->db_conn);
					if (!$res)
						return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
					$newRow = mysql_fetch_row($res);

					// now count levels between this target and the former one
					// (not the old one--the one on the same level as where we're moving)
					$query = sprintf(  "SELECT COUNT(*) FROM %s WHERE %s BETWEEN %s AND %s AND %s BETWEEN %s AND %s;",
									$parent->tree->table,
									$newRow[0],
									$parent->tree->leftFld,
									$parent->tree->rightFld,
									$parent->tree->leftFld,
									$row[0],
									$row[1]);

					$res = mysql_query($query, $this->tree->db_conn);
					if (!$res)
						return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
					$depthCount = mysql_fetch_row($res);
	
					$newRow[0] += $depthCount[0] + 1;
					$row[0]     = $newRow[0];
				}
			}
		}
		return $row[0];
	}

	/**
	 * Finds right-most insertion point under given parent
	 *
	 * @param $parent object
	 * @param $insert_item string (optional)
	 * @access private
	 * @return int [= one less than insertion point; or error code]
	 */
	function _findTargetRM($parent, $insert_item = NULL)
	{
		// probably combine the first two queries into 1 select lft where between l and r order by l desc limit 1

		// get lft,rgt of parent
		$query = sprintf(  "SELECT %s, %s FROM %s WHERE %s = %s;",
								$parent->tree->leftFld,
								$parent->tree->rightFld,
								$parent->tree->table,
								$parent->tree->idFld,
								$parent->id);

		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

		$numRows = mysql_num_rows($res);
		if ($numRows != 1)
			return $this->_raiseError(TFNS_ERROR_NODE_NOT_FOUND, __FUNCTION__, __LINE__, __FILE__, $query);

		// if has children find right-most one
		$row = mysql_fetch_row($res);
		if ($row[1] - $row[0] != 1)  // parent has other children
		{
			$query = sprintf(  "SELECT MAX(%s) FROM %s WHERE %s BETWEEN %s AND %s;",
									$parent->tree->leftFld,
									$parent->tree->table,
									$parent->tree->leftFld,
									$row[0],
									$row[1]);

			$res = mysql_query($query, $this->tree->db_conn);
			if (!$res)
				return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

			$newRow = mysql_fetch_row($res);
			// echo "newrow: $newRow[0]<br />";
			// now count levels between this target and the former one
			// (not the old one--the one on the same level as where we're moving)
			$query = sprintf(  "SELECT COUNT(*) FROM %s WHERE %s BETWEEN %s AND %s AND %s BETWEEN %s AND %s;",
							$parent->tree->table,
							$newRow[0],
							$parent->tree->leftFld,
							$parent->tree->rightFld,
							$parent->tree->leftFld,
							$row[0],
							$row[1]);

			$res = mysql_query($query, $this->tree->db_conn);
			if (!$res)
				return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
			$depthCount = mysql_fetch_row($res);

			// note the -1--it is + 1 in the other findTarget
			$newRow[0] += $depthCount[0] - 1;
			$row[0] = $newRow[0];
		}
		// echo "target $row[0]";
		return $row[0];
	}

	/**
	 * @param  $parent    object
	 * @param  $sortValue string
	 * @param  $values    array
	 * @access public
	 * @return int [id if successful error if fail]
	 */
	function insertNode($parent, $values, $linkvalue, $codevalue,$searchkeyvalue,$searchkeyvalue2,$searchkeyvalue3,$searchkeyvalue4,$searchkeyvalue5,$approachvalue, $sortValue)
	{
		if (count($parent->tree->otherFlds) != count($values))
		{
			return $this->_raiseError(TFNS_ERROR_INSERT_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
		}

		$locks = array($this->tree->table . ' WRITE', 
					$this->tree->table . ' AS P WRITE', 
					$this->tree->table . ' AS C WRITE', 
					$this->tree->table . ' AS S WRITE');
		
		$res = $this->_beginTrx($locks);
		if ($res < 1)
			return $res;

		$res = $this->_safeInsertNode($parent, $values, $linkvalue, $codevalue, $searchkeyvalue,$searchkeyvalue2,$searchkeyvalue3,$searchkeyvalue4,$searchkeyvalue5,$approachvalue,$sortValue);

		return $this->_endTrx($res);
	}

	/**
	 * Insert a new node under the specified parent.
	 * update lft = target + 1 and rgt = target + 2
	 * update lft and rgt of all terms + 2
	 *
	 * @param  $parent    object
	 * @param  $sortValue string
	 * @param  $values    array
	 * @access private
	 * @return int [id id success error if fail]
	 */
	function _safeInsertNode($parent, $values, $linkvalue, $codevalue,$searchkeyvalue,$searchkeyvalue2,$searchkeyvalue3,$searchkeyvalue4,$searchkeyvalue5,$approachvalue, $sortValue)
	{
		// FIXME - maybe all $this objects should be $parent objects?
		$target = $this->_findTarget($parent, $sortValue);
		if ($target < 1)
			return $target;

		// make space for new row
		$query = sprintf(  "UPDATE %s SET %s = %s + 2 WHERE %s > %s;",
								$this->tree->table,
								$this->tree->rightFld,
								$this->tree->rightFld,
								$this->tree->rightFld,
								$target);

		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);

		// make space for new row
		$query = sprintf(  "UPDATE %s SET %s = %s + 2 WHERE %s > %s;",
								$this->tree->table,
								$this->tree->leftFld,
								$this->tree->leftFld,
								$this->tree->leftFld,
								$target);

		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
		
		//Compliant Code
		$cv="%$codevalue%";
         $query=sprintf( "SELECT max(substring(%s,9,5)) from %s where %s like '%s';",
								$this->tree->codeFld,
		 						$this->tree->table,
								$this->tree->codeFld,
								$cv);
								
		$res = mysql_query($query, $this->tree->db_conn) or die(mysql_error());
		$row=mysql_fetch_row($res);
		echo "CODE ".$row[0];
		if(empty($row[0]))
		   { 
				$code=$codevalue.'10001'; 
			}
		  else
			 { 
				$code=$row[0]+1; 
				$code=$codevalue.$code;
			 } 
		 

		$fieldStr = implode(", ", $this->tree->otherFlds);
		$valueStr = implode("', '", $values);

		// insert row
		$query = sprintf(  "INSERT INTO %s (%s, %s, %s, %s, %s, %s, %s,%s,%s,%s,%s, %s) VALUES (NULL, '%s', %s + 1 , %s + 2, '%s', '%s','%s','%s','%s','%s','%s','%s');",
								$this->tree->table,
								$this->tree->idFld,
								$fieldStr,
								$this->tree->leftFld,
								$this->tree->rightFld,
								$this->tree->linkFld,
								$this->tree->codeFld,
								$this->tree->searchkeyFld,
								$this->tree->searchkey2Fld,
								$this->tree->searchkey3Fld,
								$this->tree->searchkey4Fld,
								$this->tree->searchkey5Fld,																								
								$this->tree->approachFld,																
								$valueStr,
								$target,
								$target,
								$linkvalue,
								$code,
								$searchkeyvalue,
								$searchkeyvalue2,
								$searchkeyvalue3,
								$searchkeyvalue4,
								$searchkeyvalue5,																																
								$approachvalue);

		$res = mysql_query($query, $this->tree->db_conn);

		if (!$res)
		{
			return $this->_raiseError(TFNS_ERROR_QUERY_FAILED, __FUNCTION__, __LINE__, __FILE__, $query);
		}	
		else
			return mysql_insert_id($this->tree->db_conn);
	}

	/**
	 * @param  $parent object
	 * @access public
	 * @return int --id of node (its new if moved to different table) or negative error code
	 */
	function deleteSubtree()
	{
		$locks = array($this->tree->table . ' WRITE');

		$res = $this->_beginTrx($locks);
		if ($res < 1)
			return $res;

		$res = $this->_safeDeleteSubtree();

		return $this->_endTrx($res);
	}

	/**
	 * @access private
	 * @return int
	 */
	function _safeDeleteSubtree()
	{
		if (!$this->up2date)
		{
			$res = $this->_setNodeProps();
			if ($res < 1)
				return $res;
		}
			
		$query = sprintf(  "DELETE FROM %s WHERE %s BETWEEN %s AND %s;",
								$this->tree->table,
								$this->tree->leftFld,
								$this->left,
								$this->right);

		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return 0;

		$subtree_size = $this->right - $this->left + 1;

		// close gaps--would this be faster with two separate queries?
		$query = sprintf(  "UPDATE %s SET %s = CASE WHEN %s > %s THEN %s - %s ELSE %s END, ".
						             "%s = CASE WHEN %s > %s THEN %s - %s ELSE %s END;",
								$this->tree->table,
								$this->tree->leftFld,
								$this->tree->leftFld,
								$this->left,
								$this->tree->leftFld,
								$subtree_size,
								$this->tree->leftFld,
								$this->tree->rightFld,
								$this->tree->rightFld,
								$this->left,
								$this->tree->rightFld,
								$subtree_size,
								$this->tree->rightFld);
								
		$res = mysql_query($query, $this->tree->db_conn);
		if (!$res)
			return 0;

		return 1;
	}

	/**
	 * we need this if we want to delete a root_node but not its children--promote them?
	 * this function hasn't been tested yet.  It probably doesn't work yet
	 *
	 * @access public
	 * @return int
	 */
	function deleteNode()
	{
		// this doesn't work yet
		return 0;

		$query = "DELETE FROM $this->table WHERE $this->idFld = $this->id;";
		$res = mysql_query($query, $this->db_conn);
		if (!$res)
			return 0;

		// close gaps
		$query = "UPDATE $this->table SET $this->leftFld = CASE WHEN $this->leftFld BETWEEN $this->left AND $this->right ".
													"THEN $this->leftFld - 1 ".
													"WHEN $this->leftFld > $this->right ".
													"THEN $this->leftFld - 2 ".
													"ELSE $this->leftFld END, ".
								   "$this->rightFld = CASE WHEN $this->rightFld BETWEEN $this->left AND $this->right ".
													"THEN $this->rightFld - 1 ".
													"WHEN $this->rightFld > $this->right ".
													"THEN $this->rightFld - 2 ".
													"ELSE $this->rightFld END ".
							    		 "WHERE $this->leftFld > $this->left;";
		$res = mysql_query($query, $this->db_conn);
		if (!$res)
			return 0;

		return 1;
	}
}

/*************************************************************************************/

class TF_ns_tree
{
	var $db_conn;
	var $table;
	var $tableType;
	var $idFld;
	var $leftFld;
	var $rightFld;
	var $orderByFld; // array of fields to sort by
	var $otherFlds;  // array of all other fields in the table other than id, lft, rgt
	var $debug;
	var $display;
	var $linkFld;
	var $codeFld;
	var $searchkeyFld;
	var $searchkey2Fld;
	var $searchkey3Fld;
	var $searchkey4Fld;
	var $searchkey5Fld;				
	var $approachFld;

	/**
	 * Nested sets table object constructor
	 *
	 * @param  $db_conn   int
	 * @param  $table     string
	 * @param  $tableType string
	 * @param  $fields    array
	 * @param  $debug     bool
	 * @access public
	 * @return null
	 */
	function TF_ns_tree($db_conn, $table, $tableType, $fields, $debug = FALSE)
	{
		$this->db_conn    = $db_conn;
		$this->table      = $table;
		$this->tableType  = $tableType;
		$this->idFld      = $fields['id'];
		$this->leftFld    = $fields['left'];
		$this->rightFld   = $fields['right'];
		$this->orderByFld = $fields['orderby'];
		$this->otherFlds  = $fields['other'];
		$this->displayFld = $fields['display'];
		$this->debug      = $debug;
		$this->linkFld	  = $fields['lnk'];
		$this->codeFld	  = $fields['compcode'];
		$this->searchkeyFld = $fields['searchkey'];
		$this->searchkey2Fld = $fields['searchkey2'];
		$this->searchkey3Fld = $fields['searchkey3'];
		$this->searchkey4Fld = $fields['searchkey4'];
		$this->searchkey5Fld = $fields['searchkey5'];								
		$this->approachFld = $fields['approach'];		
	}

	/**
	 * Returns id of root node
	 */
	function getRootId()
	{
		$query = sprintf( "SELECT %s FROM %s WHERE %s = 1;",
							$this->idFld,
							$this->table,
							$this->leftFld);

		$result = mysql_query($query, $this->db_conn);
		if (!$result)
			return -1;
			
		$row = mysql_fetch_array($result);
		
		return $row[0];
	}

	/**
	 * this requires at least mysql-4.1.2 because of bug in UNION
	 * fix--the "select max(%s)..." subquery should probably be from the rgt lft union again.
	 *
	 * @param  $printErrors bool
	 * @access public
	 * @return int
	 */

	/**
	 * This probably doesn't work yet
	 * Convert Nested Sets to Adjacency list
	 * FYI this is a correlated subquery
	 *
	 * @param $parentField string
	 * @access public
	 * @return int
	 */
	function nsToAl($parentField)
	{
		// can't update and select from same table--must use temporary table
		$query = "CREATE TEMPORARY TABLE T1 (id int unsigned, parent int unsigned);";
		$res = mysql_query($query, $this->db_conn);
		if (!$res)
			return 0;

		$query = sprintf("INSERT INTO T1 (id) SELECT %s FROM %s;",
							$this->idFld,
							$this->table);
		$res = mysql_query($query, $this->db_conn);
		
		if (!$res)
			return 0;

		// this is VERY slow
		$query = sprintf("  UPDATE T1 SET %s = ".
							"(SELECT P.%s FROM %s AS C ".
							"LEFT JOIN %s AS P ON P.%s = ".
								"(SELECT MAX(%s) FROM %s AS S WHERE C.%s > S.%s AND C.%s < S.%s) ".
							"WHERE C.%s = T1.%s);",
								$parentField,
								$this->idFld,
								$this->table,
								$this->table,
								$this->leftFld,
								$this->leftFld,
								$this->table,
								$this->leftFld,
								$this->leftFld,
								$this->leftFld,
								$this->rightFld,
								$this->idFld,
								$this->idFld);

		$res = mysql_query($query, $this->db_conn);
		if (!$res)
			return 0;

		$query = sprintf(  "UPDATE %s, T1 SET %s.%s = T1.parent WHERE %s.%s = T1.id;",
								$this->table,
								$this->table,
								$parentField,
								$this->table,
								$this->idFld);
		$res = mysql_query($query, $this->db_conn);
		if (!$res)
			return 0;

		$query = "DROP TABLE T1;";
		$res = mysql_query($query, $this->db_conn);
		if (!$res)
			return 0;

		return 1;
	}

	/**
	 * look for a way to speed this up by checking has_children flag
	 * It might be a good idea to wrap this in BEGIN COMMIT statments--test for ROLLBACK after each UPDATE
	 * no that's bad idea.  Only reason to do this is if its corrupt anyway
	 *
	 * @param  $parentFld   string
	 * @param  $parent      int
	 * @param  $left        int
	 * @access public
	 * @return int
	 */
	function rebuild($parentFld, $parent = 0, $left = 1)
	{
		// the right value of this node is the left value + 1
		$right = $left + 1;

		// get all children of this node
		$query = sprintf(  "SELECT %s FROM %s WHERE %s = %s ORDER BY %s;",
								$this->idFld,
								$this->table,
								$parentFld,
								$parent,
								$this->orderByFld);
								
		$result = mysql_query($query, $this->db_conn);

		while ($row = mysql_fetch_array($result))
		{
			// recursive execution of this function for each
			// child of this node
			// $right is the current right value, which is
			// incremented by the rebuild_tree function
			$right = $this->rebuild($parentFld, $row[0], $right);
		}
		// we've got the left value, and now that we've processed
		// the children of this node we also know the right value
		$query2 = sprintf(  "UPDATE %s SET %s = %s, %s = %s WHERE %s = %s;",
								$this->table,
								$this->leftFld,
								$left,
								$this->rightFld,
								$right,
								$this->idFld,
								$parent);
								
		$result2 = mysql_query($query2, $this->db_conn);

		// return the right value of this node + 1
		return $right + 1; 
	}
	
	
}
?>
